/************************************************************************
*
* Copyright:
*	Freescale Semiconductor, INC. All Rights Reserved.  
*  You are hereby granted a copyright license to use, modify, and
*  distribute the SOFTWARE so long as this entire notice is
*  retained without alteration in any modified and/or redistributed
*  versions, and that such modified versions are clearly identified
*  as such. No licenses are granted by implication, estoppel or
*  otherwise under any patents or trademarks of Freescale Semiconductor, 
*  Inc. This software is provided on an "AS IS" basis and without warranty.
*
*  To the maximum extent permitted by applicable law, FREESCALE 
*  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
*  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
*  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
*  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
*  ACCOMPANYING WRITTEN MATERIALS.
* 
*  To the maximum extent permitted by applicable law, IN NO EVENT
*  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
*  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
*  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
*  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
* 
*  Freescale assumes no responsibility for the maintenance and support
*  of this software
*************************************************************************
*
*  FILE NAME: fir16.h
*
*  PURPOSE: FIR16 functions and data structures declarations
*
*  AUTHOR: Andrey Butok
*	Modified by Igor Drozdinsky
*
***********************************************************************/
#ifndef _FIR_16_H_
#define _FIR_16_H_

#include "fir.h"

typedef struct tFir16Struct
	{
	Frac16* 		pFirCoef;		    // Coefficients for FIR -> {a0,a1,a2...}
	unsigned int    iFirCoefCount;	    // Number of Coefficients
	Frac16* 		pFirHistory;		// Buffer for Save hisory between function calls-> {X1,X2,X3...}
	unsigned int    iFirHistoryCount;	// Number of values in History Buffer
	};

/************************************************************************
*     Function Prototypes
************************************************************************/
 //Computes a Finite Impulse Response for a array of 16-bit fractional data values.
 struct tFir16Struct* FIR16Create( Frac16* pCoef, uint16 u16Num);
 
 void FIR16Destroy( struct tFir16Struct* pFIR);

 void FIR16_EMAC(struct tFir16Struct *pFIR, Frac16* pX, Frac16* pY, unsigned int n);
 void FIR16_MAC(struct tFir16Struct *pFIR, Frac16* pX, Frac16* pY, unsigned int n);

#ifdef __EMAC
	#define FIR16(w,x,y,z)	FIR16_EMAC(w,x,y,z)
#else
	#define FIR16(w,x,y,z)	FIR16_MAC(w,x,y,z)
#endif

 
#endif //_FIR_16_H_



